/**
  Based of StreamHTTPClient.ino and JPEGDecoder 
  Works with Board vesion 2.3.0 nothing newer ( Seems Stream function Broke in newer versions )

  Uses standard hookup or TFT_eSPI on ESP8266 with ILI9341
  Display SDO/MISO  to NodeMCU pin D6 (or leave disconnected if not reading TFT)
  Display LED       to NodeMCU pin VIN (or 5V, see below)
  Display SCK       to NodeMCU pin D5
  Display SDI/MOSI  to NodeMCU pin D7
  Display DC (RS/AO)to NodeMCU pin D3
  Display RESET     to NodeMCU pin D4 (or RST, see below)
  Display CS        to NodeMCU pin D8 (or GND, see below)
  Display GND       to NodeMCU pin GND (0V)
  Display VCC       to NodeMCU 5V or 3.3V
*/

#include <ESP8266WiFi.h>
#include <ESP8266WiFiMulti.h>
#include <ESP8266HTTPClient.h>
#include <JPEGDecoder.h>
#include "TFT_eSPI.h"

TFT_eSPI tft = TFT_eSPI();

#define USE_SERIAL Serial

ESP8266WiFiMulti WiFiMulti;
int pic=1;

uint8_t PicArray[15000]={0}; //Array for picture make sure under 15K 

void setup() {

    USE_SERIAL.begin(115200);
    tft.init();
    tft.setRotation(1);
    tft.fillScreen(TFT_BLACK);
    tft.setTextColor(ILI9341_GREEN);
    tft.setCursor(15,30);
    tft.setTextSize(2);
    tft.print("Hello James!!");

    USE_SERIAL.println();
    USE_SERIAL.println();
    USE_SERIAL.println();

    for(uint8_t t = 4; t > 0; t--) {
        USE_SERIAL.printf("[SETUP] WAIT %d...\n", t);
        USE_SERIAL.flush();
        delay(1000);
    }
//###################################################################

    WiFiMulti.addAP("YourSSID", "YourKey");
    
//####################################################################

}


void loop() {
if (pic>8)
 {
  pic=1;
  }
     
    //tft.fillScreen(TFT_BLACK);

    tft.fillRect(11, 26, 240,24, 0x0000);
    tft.drawRect(11, 26, 240,24, ILI9341_RED);
    tft.setTextColor(ILI9341_GREEN);
    tft.setCursor(15,30);
    tft.setTextSize(2);
    tft.print("Down Loading Pic:"+String(pic));
    USE_SERIAL.println("Down Loading Pic:"+String(pic));
    // wait for WiFi connection
    if((WiFiMulti.run() == WL_CONNECTED)) {
      GetPic();
    }
pic++;
    delay(2000);
}


void GetPic(){
        HTTPClient http;
        int totalSize=0;
        boolean chone=1;
        // configure server and url update based on your URL
        http.begin("http://10.16.10.11/tempgr/resizeimage2.php?IMG="+String(pic));  //update based on your URL
        //http.begin("http://10.16.10.11:8980/tempgr/ac/BaboonL.jpg");
        // start connection and send HTTP header
        int httpCode = http.GET();
        if(httpCode > 0) {
            // HTTP header has been send and Server response header has been handled
            USE_SERIAL.printf("[HTTP] GET... code: %d\n", httpCode);

            // file found at server
            if(httpCode == HTTP_CODE_OK) {

                // get lenght of document (is -1 when Server sends no Content-Length header)
                int len = http.getSize();
                
                // create buffer for read
                uint8_t buff[1024] = { 0 };

                // get tcp stream
                WiFiClient * stream = http.getStreamPtr();

                // read all data from server
                while(http.connected() && (len > 0 || len == -1)) {
                    size_t size = stream->available();
                    if(size) {
                        
                     int c = stream->readBytes(buff, ((size > sizeof(buff)) ? sizeof(buff) : size));
                     memcpy (PicArray+totalSize,buff,c);
                     totalSize=totalSize+c;

                        if(len > 0) {
                            len -= c;
                        }
                    }

                    yield();
                }
                USE_SERIAL.print("[HTTP] connection closed or file end.\n");

            }
        } else {
            USE_SERIAL.printf("[HTTP] GET... failed, error: %s\n", http.errorToString(httpCode).c_str());
        }

        http.end();
  
    USE_SERIAL.println("TotalS:"+String(totalSize));
    
    USE_SERIAL.print("First 10 Bytes: ");
    for (int ipt =0;ipt<11;ipt++){
    USE_SERIAL.print(PicArray[ipt],HEX);
    USE_SERIAL.print(",");
    }
    USE_SERIAL.print("\nLast 10 Bytes : ");
    for (int ipt =10;ipt>=0;ipt--){
    USE_SERIAL.print(PicArray[totalSize-ipt],HEX);
    USE_SERIAL.print(",");
    }
    USE_SERIAL.println("");
    drawArrayJpeg(PicArray,totalSize+10, 0, 0);
   //  drawArrayJpeg(PicArray,sizeof(PicArray), 0, 0);
}




